<?php
/* 
Template Name: Portfolio Blogview
*/
	global $wp_query;
    if(isset($wp_query))
    	$content_array = $wp_query->get_queried_object();
	if(isset($content_array->ID)){
    	$post_id = $content_array->ID;
	}

	$post_top = "";

	$template_uri = get_template_directory_uri();
	
	// Language Options
		$alterego_readmore = __('Read More', 'alterego');
		$alterego_by = __('by', 'alterego');
		$alterego_in = __('in', 'alterego');
		$alterego_tags = __('Tags', 'alterego');
		$alterego_comments = __('Comments', 'alterego');
		$alterego_categories = __('Categories','alterego');
		$alterego_nocomments = __('No Comments', 'alterego');
		$alterego_onecomment = __('1 Comment', 'alterego');
		$alterego_comments = __('Comments', 'alterego');
		$alterego_view = __('View Details','alterego');
		$alterego_sharethis = __('Share This Post', 'alterego');

	// Page Options
		$pagecustoms = getOptions($post_id);	

		if(isset($pagecustoms["alterego_headline_active"])){
			$alterego_headline_active = "on";
			$alterego_head_box_title = $pagecustoms["alterego_head_box_title"];
			$alterego_head_box_content = $pagecustoms["alterego_head_box_content"];
			$alterego_head_box_layout = split("-", $pagecustoms["alterego_head_box_layout"]);
		}
		else{
			$alterego_headline_active = "off";
			$alterego_head_box_title = "";
			$alterego_head_box_content = "";
		}

		if(isset($pagecustoms["alterego_header_title"]) && $pagecustoms["alterego_header_title"]!="")
			$alterego_headline = $pagecustoms["alterego_header_title"];
		else
			$alterego_headline = get_the_title($post_id);

		// Sidebar
			if(isset($pagecustoms["alterego_activate_sidebar"])){
				$alterego_activate_sidebar="on";
				$sidebar_orientation = $pagecustoms["alterego_sidebar_orientation"];
				$sidebar = $pagecustoms["alterego_sidebar"];
				$post_top_width = 715;
				$left_size  = "four_fifth";
				$right_size = "one_fifth"; 
				if($sidebar_orientation=="right"){
					$content_style="";
					$content_lastcolumn = "";
					$sidebar_lastcolumn = "lastcolumn";
				}
				else{
					$content_style='style="float:right;"';
					$content_lastcolumn = "lastcolumn";
					$sidebar_lastcolumn = "";
				}
			}
			else{
				$post_top_width = 470;
				$alterego_activate_sidebar="off";
				$left_size  = "five_sixth";
				$right_size = "one_sixth";
			}

		//Portfolio
			if (isset($pagecustoms["alterego_portfolio"])){
				$ptype = $pagecustoms['alterego_portfolio'];
				$pcat = "category_".$ptype;
				$pcat_array = get_option('alterego_portfolio_slug');
				$pcat_index = array_search($ptype, $pcat_array);
			}

		// Portfolio Options
		if ( function_exists( 'get_option_tree') ) {
			//Post Info Line
				if(get_option_tree( 'alterego_portfolio_postinfo_author_active' )) $alterego_portfolio_postinfo_author_active="on"; else $alterego_portfolio_postinfo_author_active="off";
				if(get_option_tree( 'alterego_portfolio_postinfo_categories_active' )) $alterego_portfolio_postinfo_categories_active="on"; else $alterego_portfolio_postinfo_categories_active="off";
				if(get_option_tree( 'alterego_portfolio_tags_active' )) $alterego_portfolio_tags_active="on"; else $alterego_portfolio_tags_active="off";
				if(get_option_tree( 'alterego_portfolio_postinfo_comments_active' )) $alterego_portfolio_postinfo_comments_active="on"; else $alterego_portfolio_postinfo_comments_active="off";
		
			$alterego_posts_per_page = get_option_tree( 'alterego_portfolio_posts_per_page' );

			//Socials
				if(get_option_tree( 'alterego_portfolio_overview_socials_active' )) $alterego_portfolio_overview_socials_active="on"; else $alterego_portfolio_overview_socials_active="off";
				if(get_option_tree( 'alterego_portfolio_overview_socials_twitter' )) {
					$alterego_portfolio_overview_socials_twitter="on"; 
					$alterego_portfolio_overview_socials_twitter_script = '<script type="text/javascript" src="http://platform.twitter.com/widgets.js"></script>';
				}
				else {
					$alterego_portfolio_overview_socials_twitter="off";
					$alterego_portfolio_overview_socials_twitter_script = "";
				}
				if(get_option_tree( 'alterego_portfolio_overview_socials_google' )){
					$alterego_portfolio_overview_socials_google="on"; 
					$alterego_portfolio_overview_socials_google_script = '<script type="text/javascript" src="https://apis.google.com/js/plusone.js"></script>';
				}	
				else {
					$alterego_portfolio_overview_socials_google="off";
					$alterego_portfolio_overview_socials_google_script = "";
				}
				if(get_option_tree( 'alterego_portfolio_overview_socials_facebook' )){
					$alterego_portfolio_overview_socials_facebook="on"; 
				}
				else $alterego_portfolio_overview_socials_facebook="off";
				if(get_option_tree( 'alterego_portfolio_overview_socials_pinterest' )){
					$alterego_portfolio_overview_socials_pinterest="on"; 
					$alterego_portfolio_overview_socials_pinterest_script = '<script type="text/javascript" src="http://assets.pinterest.com/js/pinit.js"></script>';
				}
				else{
					$alterego_portfolio_overview_socials_pinterest="off";
					$alterego_portfolio_overview_socials_pinterest_script = "";
				}
		}	

?>    

<?php get_header(); ?>

<?php 
										// Query for Portfolio
											$paged =
												( get_query_var('paged') && get_query_var('paged') > 1 )
												? get_query_var('paged')
												: 1;			
											$args=array(
						    					'post_type' => $ptype,
						    					'posts_per_page' => $alterego_posts_per_page,
						    					'paged' => $paged
							    			);
							    			
							    			$temp = $wp_query; 
							    			$wp_query = null;
							    			$wp_query = new WP_Query();
							    			$wp_query->query($args);

							    			$item_counter=1;

							?>


						
						<!--
						##############################
							- CONTENT -
						##############################
						-->
			
																		
						
						
						<?php if($alterego_activate_sidebar=="on"){
							echo '<div class="three_fourth withsidebar '.$content_lastcolumn.'" '.$content_style.'>';
						}?>
						
						
							<h3><?php echo $alterego_headline; ?></h3>

							

							<?php if(have_posts()) : while(have_posts()) : the_post();
										$post_time_daymonthyear = date_i18n(get_option('date_format'), strtotime($post->post_date_gmt));
										$post_time_day = get_post_time('j', true);
        								$post_time_monthyear = get_post_time('M Y', true);
										$posttags = get_the_tags();
										$postcustoms = getOptions($post->ID);
										$portfolioimageurl="";
										$portfolioimageurl = aq_resize(wp_get_attachment_url( get_post_thumbnail_id($post->ID)),$post_top_width);
												
										$scalevid="";			
										if(isset($postcustoms["alterego_post_type"]))
											switch ($postcustoms["alterego_post_type"]) {
												case 'image': 
													$media_class="fh-note";
													if($portfolioimageurl!=""){
														$post_top = '<div class="fullcover"></div><div class="viewproject"><a href="'.get_permalink().'">'.$alterego_view.'</a></div><img class="portfolio_image" src="'.$portfolioimageurl.'">';
													}
												break;
												
												case 'audio':
													$media_class="fh-audio";
													$post_top = '<audio id="player3"  width="100%" src="'.$postcustoms["alterego_audio_link"].'" type="audio/mp3" controls="controls"></audio>';
												break;
												
												case 'video':
													$media_class="fh-video";
													$video_width = $postcustoms["alterego_video_width"];
													$video_height = $postcustoms["alterego_video_height"];

													/*if($video_width>$post_top_width)
														$video_width_ratio = $video_width/$post_top_width;
													else
														$video_width_ratio = $post_top_width/$video_width;

													$video_height = $video_height*$video_width_ratio;
													$video_width = $post_top_width;*/

													if($postcustoms["alterego_video_type"]=="youtube"){
														$scalevid = "scalevid";
														$post_top = '<iframe src="http://www.youtube.com/embed/'.$postcustoms["alterego_youtube_id"].'?hd=1&wmode=opaque&autohide=1&showinfo=0" width="'.$video_width.'" height="'.$video_height.'" style="margin-bottom: -6px;" frameborder="0"></iframe>';

													}
													elseif ($postcustoms["alterego_video_type"]=="vimeo") {
														$scalevid = "scalevid";
														$post_top = '<iframe src="http://player.vimeo.com/video/'.$postcustoms["alterego_vimeo_id"].'?title=0&byline=0&portrait=0&color='.str_replace("#", "", get_option_tree("alterego_main_color_1")).'" width="'.$video_width.'" height="'.$video_height.'" style="margin-bottom: -6px;" frameborder="0"></iframe>';
													}
													elseif ($postcustoms["alterego_video_type"]=="flv") {
														$portfolioimageurl="";
														$portfolioimageurl = aq_resize(wp_get_attachment_url( get_post_thumbnail_id($post->ID)),$post_top_width);
														$uniq = uniqid("flv_");
														$post_top = '<div class="video-wrapper" style="width:'.$post_top_width.'px">
																						<div class="video-container"><a class="bordered" href="'.$postcustoms["alterego_flv_link"].'" style="display:block;width:'.$post_top_width.'.px;height:auto;"   id="'.$uniq.'"> 

																	</a>

																	<!-- this will install flowplayer inside previous A- tag. -->
																	<script>
																	flowplayer("'.$uniq.'", "'.$template_uri.'/js/flowplayer_plugins/flowplayer-3.2.7.swf", {
																	    clip: {autoPlay: false, autoBuffering: false}, canvas: {background:"#000000 url('.$portfolioimageurl.') no-repeat"}
																	});
																	</script></div></div>';
													}
													elseif ($postcustoms["alterego_video_type"]=="webm") {
														$post_top = '<div class="html5video">
																<iframe frameborder="0" width="100%" height="100%" style="margin-bottom: -6px;" src="'.$template_uri.'/functions/video.php?post_id='.$post->ID.'" style="overflow:hidden" bgcolor="#C9D3DE"></iframe>
															</div>
															
														';
													}
												break;
												
												case 'slider':
													$media_class="fh-photo";
													$alterego_slider = $postcustoms["alterego_slider"];
													$slider_slugs = get_option("alterego_sliders");
								                		$slider_counter = 0;
								            			foreach ( $slider_slugs as $slug ){
								                			$checked="";
								                		 	if($slug==$alterego_slider) {
								                		 		$post_top = do_shortcode('[alterego_slider name="'.get_option($slug."banner_slug").'" width='.$post_top_width.']');
								                		 	}
								                		} 	
												break;
												
												default:
													$post_top = "";
													$media_class="fh-note";
												break;

											}

										$entrycategory = "";
										$tax_cats = "";

										$terms = get_the_terms($post->ID,$pcat);

										foreach ($terms as $tax_term) {
											$tax_cats.= ', <a href="'.esc_attr(get_term_link($tax_term, $pcat)).'">'.$tax_term->name.'</a>';
										}
										$entrycategory = substr($tax_cats, 2);

										if(isset($postcustoms["alterego_header_title"]))
											$post_headline = $postcustoms["alterego_header_title"];
										else
											$post_headline = get_the_title($post->ID);
									?>				
									<div class="portfolio_full_holder">
										
										<!-- MEDIA HOLDER -->
										<div class="portfolio_leftside">
												<div class="portfolio_mediaholder <?php echo $scalevid; ?>">
													<?php echo $post_top; ?>											
												</div>
										</div>
										
										
										<!-- RIGHT HOLDER TEXT, TOPLINE, SUBLINE, HTML AND MORE -->
										<div class="portfolio_rightside">	
												<div class="insidecontainer_grey">
														<div class="topline"><h5><a href="<?php the_permalink();?>"><?php the_title(); ?></a></h5></div>
														<div class="subline">
																<div class="leftfloat"><span><?php echo $post_time_daymonthyear;?></span><?php if ($alterego_portfolio_postinfo_author_active!="off"){ ?><span><?php if($alterego_portfolio_postinfo_author_active!="off"){ echo $alterego_by." "; the_author_posts_link(); }?></span>
																<?php } ?>
																</div> 
																<?php if ($alterego_portfolio_postinfo_categories_active!="off"){ ?>
																	<div class="rightfloat">
																			<div class="leftfloat"><span><?php echo $entrycategory;?></span></div>
																			<div class="fh-category leftfloat"></div>
																	</div>
																<?php } ?>													
																<div class="clear"></div>																													
														</div>																										
												</div>
												<div class="padding20container">
													<p><?php echo the_excerpt(); ?></p>		
													<div class="divide10"></div>
													<a href="<?php the_permalink();?>" class="button main_bg_color_3"><?php echo $alterego_readmore;?></a>
													<div class="divide5"></div>									
												</div>
											
										</div>
										
										
										
										<div class="clear"></div>																				
								</div>
								<div class="blogdivider">
									<div class="divide50"></div>									
								</div>	
							<?php endwhile; endif; //have_posts ?>	
		<!-- PAGES -->
	        <?php if(function_exists('pagination')){ pagination(); echo'<div class="divide50"></div>'; }else{ paginate_links(); } ?>
	    <!-- PAGES END -->	
	    <?php if($alterego_activate_sidebar=="on"){?>
							</div>
							<div class="one_fourth sidebar <?php echo $sidebar_lastcolumn;?>" style="float:<?php echo $sidebar_orientation; ?>">
								<div class="divide45"></div>
								<?php if ( !function_exists('dynamic_sidebar') || !dynamic_sidebar($sidebar) ) : ?>
						                <h5 class="widgettitle">Sidebar Widget</h5>
				                        	Please configure this Widget in the Admin Panel under Appearance -> Widgets
				                        <div class="divide25"></div>					
										<div class="pagedivider"></div>
										<div class="divide25"></div>
				                <?php endif;?>
							</div>
		<?php } ?>
		<div class="clear"></div></div>
<?php get_footer(); ?>